
import 'package:flutter/cupertino.dart';
import 'package:flutter/material.dart';
import 'package:get/get.dart';
import 'package:viser_remit/core/route/route.dart';
import 'package:viser_remit/core/utils/my_color.dart';
import 'package:viser_remit/core/utils/my_strings.dart';
import 'package:viser_remit/core/utils/util.dart';
import 'package:viser_remit/view/screens/onboard/widget/bottom_section.dart';


import '../../../core/utils/dimensions.dart';
import '../../../core/utils/style.dart';
import '../../../data/controller/onboard/onboard_controller.dart';

class OnboardScreen extends StatefulWidget {
  const OnboardScreen({super.key});

  @override
  State<OnboardScreen> createState() => _OnboardScreenState();
}

class _OnboardScreenState extends State<OnboardScreen> {

  @override
  void initState() {
    MyUtils.onboardScreen();
    Get.put(OnboardController());
    super.initState();
  }


  @override
  Widget build(BuildContext context) {
    return GetBuilder<OnboardController>(
      builder: (controller) => Scaffold(
        backgroundColor: MyColor.colorWhite,
        body: PageView.builder(
          controller: controller.pageController,
          itemCount: controller.onboardImageList.length,
          onPageChanged: (value) {
            controller.changeCurrentIndex(value);
          },
          itemBuilder: (context, index) {
            return Stack(
              children: [

              /*  Container(
                  padding: const EdgeInsets.symmetric(horizontal: Dimensions.space16),
                  width: context.width,
                  child: Column(
                    children: [
                      SizedBox(height: context.height * .1,),
                      Text("Purchase Online",style: semiBoldLarge.copyWith(fontSize: double.parse("20"),color: MyColor.colorBlack)),
                      const SizedBox(height: Dimensions.space16,),
                      Text("Lorem Ipsum is simply dummy text of the printing and typesetting ",style: regularLarge.copyWith(fontSize: double.parse("16"),color: MyColor.colorWhite),textAlign: TextAlign.center,),
                    ],
                  ),
                ),*/

                // SizedBox(height: context.height * .04,),

                Image.asset(
                  controller.onboardImageList[index],
                  height: double.maxFinite,
                  width: double.maxFinite,
                  fit: BoxFit.cover,
                ),


                Positioned(
                  bottom: 60,
                  child: Container(
                    width: context.width,
                    alignment: Alignment.center,
                    padding: const EdgeInsets.symmetric(horizontal: Dimensions.space6),
                    child: Column(
                      mainAxisAlignment: MainAxisAlignment.center,
                      crossAxisAlignment: CrossAxisAlignment.center,
                      children: [

                        Column(
                          children: [
                            Text(controller.onboardTitleList[index].tr,style: boldLarge.copyWith(fontSize: 24,color: MyColor.colorWhite),),
                            const SizedBox(height: 10),
                            Padding(
                              padding: EdgeInsets.symmetric(horizontal: context.width * .08),
                              child: Text(controller.onboardSubTitleList[index].tr,style: regularLarge.copyWith(color: MyColor.colorWhite,fontSize: 16),textAlign: TextAlign.center,),
                            )
                          ],
                        ),
                        SizedBox(height: context.height * .08,),
                        BottomSection(index: index)
                      ],
                    ),
                  ),
                ),
              ],
            );
          },
        ),
      ),
    );
  }
}




